/**
 * Demonstration
 * CS 124
 * University of Vermont
 * Egbert Porcupine
 * 2020-Jul-05
 */

#include <fstream>
#include <iostream>

int main() {

    std::ifstream ifs;  // input file stream
    ifs.open ("../states.csv");
    if (ifs) {
        char comma = ',';
        std::string sname;
        int population;
        std::string abbr;
        while(ifs && ifs.peek() != EOF) {
            std::getline(ifs, sname, comma);
            // read state name; comma is delimiter
            ifs >> population;  // read next field into pop
            ifs >> comma;  // get that comma
            std::getline(ifs, abbr);  // finish up the line
            std::cout << sname << " | "
                      << population << " | "
                      << abbr
                      << std::endl;
            // Here we just print to show that we correctly
            // extracted data from the file. This is where
            // you'd likely create some object and add the
            // object to a vector of objects.
        }
    } else {
        std::cout << "Unable to read from file." << std::endl;
    }
    ifs.close();
    return 0;
}