/**
 * Demonstration
 * CS 124
 * University of Vermont
 * Egbert Porcupine
 * 2020-Jul-05
 */

#include <fstream>
#include <iostream>

int main() {
    std::ifstream ifs;  // input file stream
    ifs.open("../albums.csv");
    std::string throwAway;
    std::getline(ifs, throwAway);  // toss the first line with field names
    if (ifs) {
        // Here we have added complexity that some album titles
        // are quoted because they contain commas.
        // A line might look like this:
        //     Eric Dolphy,Iron Man
        // but it might also look like this:
        //     Evan Parker,"Ericle of Dolphi, The"
        char comma = ',', doubleQuote = '"';
        std::string artist, title, yearStr;
        int year;
        while(ifs && ifs.peek() != EOF) {
            std::getline(ifs, artist, comma);  // get artist (up to first comma)
            if (ifs.peek() == doubleQuote) {  // is the next char " ?
                ifs >> doubleQuote;  // if so, consume it
                std::getline(ifs, title, doubleQuote);  // consume to the next "
                ifs >> comma;  // consume the following comma
            } else {
                std::getline(ifs, title, comma);  // otherwise consume to next ,
            }
            std::getline(ifs, yearStr);  // consume to newline
            year = std::stoi(yearStr);  // optionally convert string to int

            std::cout << artist << " | "
                      << title << " | "
                      << year
                      << std::endl;
        }
    } else {
        std::cout << "Unable to read from file." << std::endl;
    }
    ifs.close();
    return 0;
}